/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.EntryUtils;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.internal.contentAssist.AcceptAllContextFilter;
import com.aptana.editor.php.internal.contentAssist.CallInfo;
import com.aptana.editor.php.internal.contentAssist.IContextFilter;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ProposalContext;
import com.aptana.editor.php.internal.indexer.ClassPHPEntryValue;
import com.aptana.editor.php.internal.indexer.FunctionPHPEntryValue;
import com.aptana.editor.php.internal.indexer.NamespacePHPEntryValue;
import com.aptana.editor.php.internal.parser.nodes.IPHPParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPClassParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPFunctionParseNode;
import com.aptana.editor.php.internal.parser.nodes.PHPNamespaceNode;
import com.aptana.editor.php.internal.parser.nodes.Parameter;
import com.aptana.editor.php.internal.text.link.contentassist.LineBreakingReader;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.Lexeme;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org2.eclipse.php.core.compiler.PHPFlags;

public class PHPContextCalculator {
    protected static final String EXTENDS_PROPOSAL_CONTEXT_TYPE = "EXTENDS_PROPOSAL_CONTEXT_TYPE";
    protected static final String IMPLEMENTS_PROPOSAL_CONTEXT_TYPE = "IMPLEMENTS_PROPOSAL_CONTEXT_TYPE";
    protected static final String NEW_PROPOSAL_CONTEXT_TYPE = "NEW_PROPOSAL_CONTEXT_TYPE";
    protected static final String NAMESPACE_PROPOSAL_CONTEXT_TYPE = "NAMESPACE_PROPOSAL_CONTEXT_TYPE";
    protected static final String TRAIT_USE_PROPOSAL_CONTEXT_TYPE = "TRAIT_USE_PROPOSAL_CONTEXT_TYPE";
    protected static final String TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE = "TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE";
    protected static final String VARIABLE_TYPE_PROPOSAL_CONTEXT_TYPE = "VARIABLE_TYPE_PROPOSAL_CONTEXT_TYPE";
    private static final String NEW_LINE = System.getProperty("line.separator", "\r\n");
    public static final String DEFAULT_DELIMITER = String.valueOf(NEW_LINE) + "\u2022\t";
    private static final int[] EMPTY_TYPES = new int[0];
    private ProposalContext currentContext;
    private Character insertedChar;

    public ProposalContext calculateCompletionContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, boolean reportedScopeIsUnderClass) {
        this.internalCalculateContext(lexemeProvider, offset, reportedScopeIsUnderClass);
        return this.currentContext;
    }

    public ProposalContext calculateCompletionContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, char insertedChar, boolean reportedScopeIsUnderClass) {
        this.insertedChar = Character.valueOf(insertedChar);
        ProposalContext context = this.calculateCompletionContext(lexemeProvider, offset, reportedScopeIsUnderClass);
        this.insertedChar = null;
        return context;
    }

    private void internalCalculateContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, boolean reportedScopeIsUnderClass) {
        this.currentContext = new ProposalContext(new AcceptAllContextFilter(), true, true, null);
        int lexemePosition = lexemeProvider.getLexemeFloorIndex(offset - 1);
        if (this.checkLineCommentContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkPHPDocContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkClassDeclarationContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkImplementsDeclarationContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkExtendsDeclarationContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkClassExtendsOrImplementsContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkFunctionDeclarationContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkNewInstanceContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (reportedScopeIsUnderClass && this.checkTraitUseContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
        if (this.checkTraitUseBlockContext(lexemeProvider, offset, lexemePosition) && (this.checkTraitUseAfterKeywordContext(lexemeProvider, offset, lexemePosition) || this.checkTraitUseBeforeKeywordContext(lexemeProvider, offset, lexemePosition))) {
            return;
        }
        if (this.checkNamespaceUseContext(lexemeProvider, offset, lexemePosition)) {
            return;
        }
    }

    private boolean checkClassDeclarationContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        if (lexemePosition == 0) {
            return false;
        }
        Lexeme<PHPTokenType> nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_CLASS", new String[]{"PHP_NS_SEPARATOR"});
        if (nearestKeyWord == null && (nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_INTERFACE", new String[]{"PHP_NS_SEPARATOR"})) == null) {
            return false;
        }
        this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
        return true;
    }

    private boolean checkClassExtendsOrImplementsContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        if (lexemePosition == 0) {
            return false;
        }
        Lexeme<PHPTokenType> nearestClassKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_CLASS", new String[]{"PHP_STRING", "WHITESPACE", "PHP_TOKEN", "PHP_EXTENDS"});
        if (nearestClassKeyWord == null && (nearestClassKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_INTERFACE", new String[]{"PHP_STRING", "WHITESPACE", "PHP_TOKEN"})) == null) {
            return false;
        }
        final boolean declaredClass = "PHP_CLASS".equals(((PHPTokenType)nearestClassKeyWord.getType()).getType());
        Lexeme<PHPTokenType> extendsToken = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_EXTENDS", new String[]{"PHP_STRING", "WHITESPACE", "PHP_TOKEN", "PHP_IMPLEMENTS"});
        Lexeme<PHPTokenType> implementsToken = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_IMPLEMENTS", new String[]{"PHP_STRING", "WHITESPACE", "PHP_TOKEN"});
        final boolean alreadyHaveExtends = extendsToken != null;
        final boolean alreadyHaveImplements = implementsToken != null;
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return builtinElement instanceof IPHPParseNode && (!alreadyHaveExtends && "extends".equals(((IPHPParseNode)builtinElement).getNodeName()) || !alreadyHaveImplements && declaredClass && "implements".equals(((IPHPParseNode)builtinElement).getNodeName()));
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return false;
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, false, EMPTY_TYPES);
        this.currentContext.setAutoActivateCAAfterApply(true);
        return true;
    }

    private boolean checkImplementsDeclarationContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        if (lexemePosition == 0) {
            return false;
        }
        if (this.checkImplementsDeclarationContextInternal(lexemeProvider, lexemePosition)) {
            return true;
        }
        return this.checkImplementsDeclarationContextInternal(lexemeProvider, lexemePosition - 1);
    }

    private boolean checkImplementsDeclarationContextInternal(ILexemeProvider<PHPTokenType> lexemeProvider, int lexemePosition) {
        Lexeme<PHPTokenType> nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_IMPLEMENTS", new String[]{"PHP_STRING", "WHITESPACE", "PHP_TOKEN"});
        if (nearestKeyWord == null) {
            return false;
        }
        Lexeme<PHPTokenType> classKeyword = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_CLASS", new String[]{"PHP_EXTENDS", "PHP_IMPLEMENTS", "PHP_STRING", "WHITESPACE", "PHP_TOKEN"});
        if (classKeyword == null) {
            this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
            return true;
        }
        Lexeme<PHPTokenType> previousNameOrToken = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, new String[]{"PHP_IMPLEMENTS", "PHP_TOKEN"}, new String[]{"WHITESPACE"});
        if (previousNameOrToken == null || ((PHPTokenType)previousNameOrToken.getType()).getType() == "PHP_TOKEN" && !PHPContextCalculator.isLexemeText(previousNameOrToken, ",")) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                PHPClassParseNode node;
                return builtinElement instanceof PHPClassParseNode && PHPFlags.isInterface((int)(node = (PHPClassParseNode)builtinElement).getModifiers());
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return element.getValue() instanceof ClassPHPEntryValue && PHPFlags.isInterface((int)((ClassPHPEntryValue)element.getValue()).getModifiers());
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, EMPTY_TYPES);
        this.currentContext.setType(IMPLEMENTS_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkExtendsDeclarationContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        if (lexemePosition == 0) {
            return false;
        }
        if (this.checkExtendsDeclarationContextInternal(lexemeProvider, lexemePosition)) {
            return true;
        }
        return this.checkExtendsDeclarationContextInternal(lexemeProvider, lexemePosition - 1);
    }

    private boolean checkExtendsDeclarationContextInternal(ILexemeProvider<PHPTokenType> lexemeProvider, int lexemePosition) {
        Lexeme<PHPTokenType> extendsOnly;
        boolean classDeclared;
        Lexeme<PHPTokenType> nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_EXTENDS", new String[]{"PHP_STRING", "WHITESPACE", "PHP_TOKEN"});
        if (nearestKeyWord == null) {
            return false;
        }
        Lexeme<PHPTokenType> classKeyword = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_CLASS", new String[]{"PHP_EXTENDS", "PHP_STRING", "WHITESPACE", "PHP_TOKEN"});
        Lexeme<PHPTokenType> interfaceKeyword = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_INTERFACE", new String[]{"PHP_EXTENDS", "PHP_STRING", "WHITESPACE", "PHP_TOKEN"});
        if (classKeyword == null && interfaceKeyword == null) {
            this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
            return true;
        }
        boolean bl = classDeclared = classKeyword != null;
        if (classDeclared && (extendsOnly = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_EXTENDS", new String[]{"WHITESPACE"})) == null) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                if (builtinElement instanceof PHPClassParseNode) {
                    PHPClassParseNode node = (PHPClassParseNode)builtinElement;
                    if (2 == node.getModifiers()) {
                        return false;
                    }
                    boolean isInterface = PHPFlags.isInterface((int)node.getModifiers());
                    if (classDeclared && !isInterface || !classDeclared && isInterface) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                if (element.getValue() instanceof ClassPHPEntryValue) {
                    ClassPHPEntryValue value = (ClassPHPEntryValue)element.getValue();
                    if (2 == value.getModifiers()) {
                        return false;
                    }
                    boolean isInterface = PHPFlags.isInterface((int)value.getModifiers());
                    if (classDeclared && !isInterface || !classDeclared && isInterface) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, EMPTY_TYPES);
        this.currentContext.setType(EXTENDS_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkFunctionDeclarationContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        if (lexemePosition == 0) {
            return false;
        }
        Lexeme<PHPTokenType> functionKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_FUNCTION", new String[]{"PHP_STRING", "PHP_TOKEN", "WHITESPACE", "PHP_VARIABLE"});
        if (functionKeyWord == null) {
            return false;
        }
        Lexeme lexeme = lexemeProvider.getLexeme(lexemePosition);
        if (this.insertedChar != null && this.insertedChar.charValue() == '$' || PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)lexeme, "$")) {
            this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
            return true;
        }
        boolean contextOK = false;
        if (this.insertedChar != null && (this.insertedChar.charValue() == ',' || this.insertedChar.charValue() == '(') || PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)lexeme, ",") || PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)lexeme, "(")) {
            contextOK = true;
        } else {
            Lexeme currentLexeme = null;
            int positionShift = this.insertedChar != null ? 0 : -1;
            int i = lexemePosition + positionShift;
            while (i >= 0) {
                currentLexeme = lexemeProvider.getLexeme(i);
                String type = ((PHPTokenType)currentLexeme.getType()).getType();
                if (type.equals("PHP_TOKEN")) {
                    if (!PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)currentLexeme, ",") && !PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)currentLexeme, "(")) break;
                    contextOK = true;
                    break;
                }
                if (!type.equals("WHITESPACE")) break;
                --i;
            }
        }
        if (!contextOK) {
            this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
            return true;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return builtinElement instanceof PHPClassParseNode;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return element.getValue() instanceof ClassPHPEntryValue;
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, EMPTY_TYPES);
        this.currentContext.setType(VARIABLE_TYPE_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkNewInstanceContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        if (lexemePosition == 0) {
            return false;
        }
        if (this.checkNewInstanceContextInternal(lexemeProvider, lexemePosition)) {
            return true;
        }
        return this.checkNewInstanceContextInternal(lexemeProvider, lexemePosition - 1);
    }

    private boolean checkNewInstanceContextInternal(ILexemeProvider<PHPTokenType> lexemeProvider, int lexemePosition) {
        Lexeme<PHPTokenType> nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_NEW", new String[]{"WHITESPACE", "PHP_NS_SEPARATOR", "PHP_STRING"});
        if (nearestKeyWord == null) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                PHPClassParseNode node;
                return builtinElement instanceof PHPClassParseNode && !PHPFlags.isInterface((int)(node = (PHPClassParseNode)builtinElement).getModifiers());
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                if (element.getValue() instanceof ClassPHPEntryValue && !PHPFlags.isInterface((int)((ClassPHPEntryValue)element.getValue()).getModifiers())) {
                    return true;
                }
                return element.getValue() instanceof NamespacePHPEntryValue;
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, EMPTY_TYPES);
        this.currentContext.setType(NEW_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkLineCommentContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        String lexemeType;
        Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
        if (firstLexeme != null && ((lexemeType = ((PHPTokenType)firstLexeme.getType()).getType()).equals("PHP_COMMENT_START") || lexemeType.equals("PHP_LINE_COMMENT"))) {
            this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
            return true;
        }
        return false;
    }

    private boolean checkPHPDocContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
        if (firstLexeme != null && ((PHPTokenType)firstLexeme.getType()).getType().equals("PHPDOC_COMMENT_START")) {
            this.currentContext = PHPContextCalculator.getDenyAllProposalContext();
            return true;
        }
        return false;
    }

    private boolean checkNamespaceUseContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        Lexeme<PHPTokenType> nearestUseKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_USE", new String[]{"WHITESPACE", "PHP_NS_SEPARATOR", "PHP_STRING"});
        if (nearestUseKeyWord == null) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return builtinElement instanceof PHPNamespaceNode;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                Object value = element.getValue();
                return value instanceof NamespacePHPEntryValue || value instanceof ClassPHPEntryValue;
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, new int[]{6});
        this.currentContext.setType(NAMESPACE_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkTraitUseContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        Lexeme<PHPTokenType> nearestUseKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_USE", new String[]{"WHITESPACE", "PHP_NS_SEPARATOR", "PHP_STRING", "PHP_TOKEN"});
        if (nearestUseKeyWord == null) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return builtinElement instanceof PHPNamespaceNode;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return EntryUtils.isTrait(element);
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, new int[]{1});
        this.currentContext.setType(TRAIT_USE_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkTraitUseBlockContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        Lexeme<PHPTokenType> nearestUseKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_USE", new String[]{"WHITESPACE", "PHP_NS_SEPARATOR", "PHP_STRING", "PHP_PAAMAYIM_NEKUDOTAYIM", "PHP_INSTEADOF", "PHP_AS", "PHP_SEMICOLON", "PHP_CURLY_OPEN", "PHP_TOKEN"});
        if (nearestUseKeyWord == null) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return false;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return EntryUtils.isTrait(element) || EntryUtils.isFunction(element) && ((FunctionPHPEntryValue)element.getValue()).isTraitMethod();
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, false, true, new int[]{1});
        this.currentContext.setType(TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkTraitUseBeforeKeywordContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        Lexeme<PHPTokenType> lexeme = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_STRING", new String[]{"WHITESPACE"});
        if (lexeme == null) {
            return false;
        }
        lexeme = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition - 1, "PHP_PAAMAYIM_NEKUDOTAYIM", new String[]{"WHITESPACE", "PHP_STRING"});
        if (lexeme == null || !((PHPTokenType)lexeme.getType()).getType().equals("PHP_PAAMAYIM_NEKUDOTAYIM")) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return "insteadof".equals(((IPHPParseNode)builtinElement).getNodeName()) || "as".equals(((IPHPParseNode)builtinElement).getNodeName());
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return EntryUtils.isFunction(element) && ((FunctionPHPEntryValue)element.getValue()).isTraitMethod();
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, null);
        this.currentContext.setType(TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    private boolean checkTraitUseAfterKeywordContext(ILexemeProvider<PHPTokenType> lexemeProvider, int offset, int lexemePosition) {
        Lexeme<PHPTokenType> nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_INSTEADOF", new String[]{"WHITESPACE"});
        if (nearestKeyWord == null) {
            nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, lexemePosition, "PHP_AS", new String[]{"WHITESPACE"});
        }
        if (nearestKeyWord == null) {
            return false;
        }
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return false;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return EntryUtils.isTrait(element) || EntryUtils.isFunction(element) && ((FunctionPHPEntryValue)element.getValue()).isTraitMethod();
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        this.currentContext = new ProposalContext(filter, true, true, new int[]{1});
        this.currentContext.setType(TRAIT_USE_BLOCK_PROPOSAL_CONTEXT_TYPE);
        return true;
    }

    public static Lexeme<PHPTokenType> findLexemeBackward(ILexemeProvider<PHPTokenType> lexemeProvider, int startPosition, Object typesToFind, String[] allowedTypesToSkip) {
        HashSet<String> typesSet = new HashSet<String>();
        if (typesToFind instanceof String) {
            typesSet.add(typesToFind.toString());
        } else {
            String[] types;
            String[] stringArray = types = (String[])typesToFind;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                typesSet.add(type);
                ++n2;
            }
        }
        int i = startPosition;
        while (i >= 0) {
            Lexeme currentLexeme = lexemeProvider.getLexeme(i);
            if (typesSet.contains(((PHPTokenType)currentLexeme.getType()).getType())) {
                return currentLexeme;
            }
            if (allowedTypesToSkip != null) {
                boolean allowedToSkip = false;
                int j = 0;
                while (j < allowedTypesToSkip.length) {
                    if (((PHPTokenType)currentLexeme.getType()).getType().equals(allowedTypesToSkip[j])) {
                        allowedToSkip = true;
                        break;
                    }
                    ++j;
                }
                if (!allowedToSkip) {
                    return null;
                }
            }
            --i;
        }
        return null;
    }

    private static ProposalContext getDenyAllProposalContext() {
        IContextFilter filter = new IContextFilter(){

            @Override
            public boolean acceptBuiltin(Object builtinElement) {
                return false;
            }

            @Override
            public boolean acceptElementEntry(IElementEntry element) {
                return false;
            }

            @Override
            public boolean acceptExternalProposals() {
                return false;
            }
        };
        return new ProposalContext(filter, false, false, EMPTY_TYPES);
    }

    static CallInfo calculateCallInfo(ILexemeProvider<PHPTokenType> lexemeProvider, int offset) {
        Lexeme<PHPTokenType> nearestKeyWord;
        int startPosition = lexemeProvider.getLexemeFloorIndex(offset - 1);
        int level = 0;
        if (startPosition > 0 && (nearestKeyWord = PHPContextCalculator.findLexemeBackward(lexemeProvider, startPosition - 1, "PHP_FUNCTION", new String[]{"PHP_STRING", "PHP_TOKEN", "WHITESPACE", "PHP_VARIABLE"})) != null) {
            return null;
        }
        int i = startPosition;
        while (i >= 0) {
            Lexeme currentLexeme = lexemeProvider.getLexeme(i);
            String type = ((PHPTokenType)currentLexeme.getType()).getType();
            if ("PHP_TOKEN".equals(type)) {
                if (PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)currentLexeme, ")")) {
                    ++level;
                } else if (PHPContextCalculator.isLexemeText((Lexeme<PHPTokenType>)currentLexeme, "(")) {
                    if (level == 0) {
                        Lexeme<PHPTokenType> function = PHPContextCalculator.findLexemeBackward(lexemeProvider, i - 1, "PHP_STRING", new String[]{"WHITESPACE", "PHP_COMMENT", "PHP_COMMENT_END", "PHP_COMMENT_START"});
                        if (function == null) {
                            return null;
                        }
                        return new CallInfo(function.getText(), function.getEndingOffset());
                    }
                    --level;
                }
            }
            --i;
        }
        return null;
    }

    static IContextInformation computeArgContextInformation(PHPFunctionParseNode pn, int nameEndOffset) {
        StringBuffer bf = new StringBuffer();
        Parameter[] parameters = pn.getParameters();
        String[] parameterNames = new String[parameters.length];
        int a = 0;
        while (a < parameters.length) {
            parameterNames[a] = parameters[a].getVariableName();
            ++a;
        }
        a = 0;
        while (a < parameters.length) {
            parameters[a].addLabel(bf);
            if (a != parameters.length - 1) {
                bf.append(", ");
            }
            ++a;
        }
        String info = bf.toString();
        ContextInformation contextInformation = new ContextInformation(info, info);
        return new PHPContextInformationWrapper(contextInformation, nameEndOffset);
    }

    static IContextInformation computeArgContextInformation(IElementEntry entry, int nameEndOffset) {
        FunctionPHPEntryValue value = (FunctionPHPEntryValue)entry.getValue();
        StringBuffer bf = new StringBuffer();
        Map<String, Set<Object>> parameters = value.getParameters();
        int i = 0;
        for (String parName : parameters.keySet()) {
            bf.append('$');
            bf.append(parName);
            if (i != parameters.size() - 1) {
                bf.append(", ");
            }
            ++i;
        }
        String info = bf.toString();
        ContextInformation contextInformation = new ContextInformation(info, info);
        return new PHPContextInformationWrapper(contextInformation, nameEndOffset);
    }

    static IContextInformation computeConstructorContextInformation(PHPClassParseNode cn, int nameEndOffset) {
        IParseNode[] children;
        IParseNode[] iParseNodeArray = children = cn.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter[] parameters;
            PHPFunctionParseNode func;
            IParseNode child = iParseNodeArray[n2];
            if (child instanceof PHPFunctionParseNode && ("__construct".equals((func = (PHPFunctionParseNode)child).getNodeName()) || cn.getNodeName().equals(func.getNodeName())) && (parameters = func.getParameters()) != null && parameters.length > 0) {
                return PHPContextCalculator.computeArgContextInformation(func, nameEndOffset);
            }
            ++n2;
        }
        return null;
    }

    static String wrapString(String s, int maxWidth, String delimiter) {
        StringBuilder result;
        GC gc;
        block7: {
            if (Display.getCurrent() == null) {
                return s;
            }
            StringReader sr = new StringReader(s);
            gc = new GC((Drawable)Display.getCurrent());
            result = new StringBuilder();
            LineBreakingReader r = new LineBreakingReader((Reader)sr, gc, maxWidth);
            try {
                try {
                    String line = r.readLine();
                    while (line != null) {
                        result.append(line);
                        line = r.readLine();
                        if (line == null) continue;
                        result.append(delimiter);
                    }
                }
                catch (IOException e) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error reading from a stream", (Throwable)e, null);
                    sr.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                sr.close();
                throw throwable;
            }
            sr.close();
        }
        gc.dispose();
        return result.toString();
    }

    static boolean isLexemeText(Lexeme<PHPTokenType> lexeme, String content) {
        return lexeme != null && content.equals(lexeme.getText());
    }

    static class PHPContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private ContextInformation contextInformation;
        private final int contextPosition;

        protected PHPContextInformationWrapper(ContextInformation information, int contextPosition) {
            this.contextInformation = information;
            this.contextPosition = contextPosition;
        }

        public String getContextDisplayString() {
            return this.contextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.contextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.contextInformation.getContextDisplayString();
        }

        public int getContextInformationPosition() {
            return this.contextPosition;
        }
    }
}

